<!DOCTYPE html>
<html xmlns:th="http://www.thymeleaf.org" xmlns:sec="http://www.thymeleaf.org/thymeleaf-extras-springsecurity5">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="description" content="">
  <meta name="author" content="">
  <title>Student Portal</title>

  <link th:rel="stylesheet" th:href="@{/webjars/bootstrap/5.1.3/css/bootstrap.min.css} " />
  <link th:rel="stylesheet" th:href="@{/styles/style.css} " />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
  <link rel="stylesheet" href="styles/style.css" />
  <link rel="stylesheet" href="styles/index.css" />
  <style>
    .background-radial-gradient {
      background-color: hsl(218, 41%, 15%);
      background-image: radial-gradient(650px circle at 0% 0%,
          hsl(218, 41%, 35%) 15%,
          hsl(218, 41%, 30%) 35%,
          hsl(218, 41%, 20%) 75%,
          hsl(218, 41%, 19%) 80%,
          transparent 100%),
        radial-gradient(1250px circle at 100% 100%,
          hsl(218, 41%, 45%) 15%,
          hsl(218, 41%, 30%) 35%,
          hsl(218, 41%, 20%) 75%,
          hsl(218, 41%, 19%) 80%,
          transparent 100%);
    }

    #radius-shape-1 {
      height: 220px;
      width: 220px;
      top: -60px;
      left: -130px;
      background: radial-gradient(#44006b, #932063);
      overflow: hidden;
    }

    #radius-shape-2 {
      border-radius: 38% 62% 63% 37% / 70% 33% 67% 30%;
      bottom: -60px;
      right: -110px;
      width: 300px;
      height: 300px;
      background: radial-gradient(#44006b, #932063);
      overflow: hidden;
    }

    .bg-glass {
      background-color: hsla(0, 0%, 100%, 0.9) !important;
      backdrop-filter: saturate(200%) blur(25px);
    }
  </style>


</head>

<body>
  <div th:include="header :: copy"></div>
  <nav>
    <a class="logo"> <img src="../assets/images/logo.jpeg">
    </a> <input class="menu-btn" type="checkbox" id="menu-btn" /> <label class="menu-icon" for="menu-btn"> <span class="nav-icon"></span>
    </label>

    <sec:authorize access="!isAuthenticated()">
      <ul class="menu" style="border-radius: 5px;">
        <li><a href="#">About</a></li>
        <li><a href="#">Connections</a></li>
        <!-- <li><a href="#"
						onclick="document.getElementById('id01').style.display='block'"
						style="width: auto; border-radius: 5px; cursor: pointer;">Join
							Now</a></li>
					<li><a href="register">Register</a></li> -->
        <li><a href="login" class="active" style="width: auto; border-radius: 5px; cursor: pointer;">Login</a></li>
      </ul>
    </sec:authorize>




    <!-- <sec:authorize access="isAuthenticated()">

				<sec:authorize access="hasRole('Users')">
				 <ul class="menu" style="border-radius: 5px;">
					 <li><a href="cars">Used Cars</a></li>
					 <li><a href="new_car">Sell Your Car</a></li>
				 </ul>
				</sec:authorize>
				
				<sec:authorize access="hasRole('Administrator')">
				<ul class="menu" style="border-radius: 5px;">
					 <li><a href="cars">Car Management </a></li>
					 <li><a href="users">User Management</a></li>
			    </ul> 
				</sec:authorize>
				
					<li>
					<form action="logout" method="post" style="padding:7px;">
						<input type="hidden" name="${_csrf.parameterName}"
							value="${_csrf.token}" />
							<input type="submit"
							name="Logout" value="Logout" class="btn btn-primary"></input>
					</form>
					</li>
				</sec:authorize>
				 -->

  </nav>

  <!-- Section: Design Block -->
  <section class="background-radial-gradient overflow-hidden">

    <div class="container px-4 py-5 px-md-5 text-center text-lg-start my-5">
      <div class="row gx-lg-5 align-items-center mb-5">
        <div class="col-lg-6 mb-5 mb-lg-0" style="z-index: 10">
          <h1 class="my-5 display-5 fw-bold ls-tight" style="color: hsl(218, 81%, 95%)">
            Learn, Innovate & Grow <br />
            <span style="color: hsl(218, 81%, 75%)">with Lithan EduCLaaS !</span>
          </h1>
          <p class="mb-4 opacity-70" style="color: hsl(218, 81%, 85%)">
            Lorem ipsum dolor, sit amet consectetur adipisicing elit.
            Temporibus, expedita iusto veniam atque, magni tempora mollitia
            dolorum consequatur nulla, neque debitis eos reprehenderit quasi
            ab ipsum nisi dolorem modi. Quos?
          </p>
        </div>

        <div class="col-lg-6 mb-5 mb-lg-0 position-relative">
          <div id="radius-shape-1" class="position-absolute rounded-circle shadow-5-strong"></div>
          <div id="radius-shape-2" class="position-absolute shadow-5-strong"></div>

          <div class="card bg-glass">
            <div class="card-body px-4 py-5 px-md-5">

              <form:form class="form-signin" method="POST" th:action="@{/update}">
                <input type="hidden" name="${_csrf.parameterName}" value="${_csrf.token}" />

                <div class="form-outline mb-4">
                  <h3 class="text-center"> New Password </h3>
                </div>

                <div class="form-outline mb-4">
                  <div th:if="${error_string}" class="alert alert-danger">
                    Invalid username and password.</div>
                </div>

                <!-- UN & PW  input -->
                <div class="form-outline mb-4">
                  <label class="form-label" for="Password">Password :</label>
                  <input type="password" id="Password" name="Password" value="" class="form-control" required />

                </div>

                <div class="form-outline mb-4">
                  <label class="form-label" for="cfrmpassword">Confirm Password :</label>
                  <input type="password" id="cfrmpassword" name="cfrmpassword" value="" class="form-control" required />

                </div>

                <input type="submit" name="Update" value="Update" class="btn btn-primary btn-block mb-4" />
              </form:form>
            </div>
          </div>
        </div>
      </div>

    </div>
  </section>
  <!-- Section: Design Block -->

  <div th:include="footer :: copy"></div>
  <div th:fragment="copy">
    <footer class="container-fluid bg-4 text-center">
      <h4>&copy; 2022 Lithan - EduClaas.</h4>
    </footer>
  </div>
</body>

</html>