<?php require "db_connect.php" ?>
<?php
require(__DIR__ . "/../global_variable.php");
// Start the session
session_start();
if (!isset($_SESSION['msatg'])) {
	header("Location:" . $redirectUrl);
}
if ($_SESSION['msatg'] == 1) {
	$_SESSION["User_Logged_In"] = true;
	$_SESSION['UserType'] = 'STUD';
	$user_email = $_SESSION['email'];

	// calling sp
	$loginValidatedUserStudentResult = mysqli_query($connection, "CALL SP_GetStudentProfileDetail('$user_email')");
	$dataFromLoginValidateUserStudentResult = [];
	while ($row = mysqli_fetch_array($loginValidatedUserStudentResult)) {
		$dataFromLoginValidateUserStudentResult[] = $row;
	}
	while (mysqli_next_result($connection)) {
	}

	if (isset($dataFromLoginValidateUserStudentResult) && !empty($dataFromLoginValidateUserStudentResult)) {
		foreach ($dataFromLoginValidateUserStudentResult as $row) {
			//print_r($row);
			$_SESSION["Profile"] = $row['Profile'];
			$_SESSION['StudentNo'] = $row['StudentNo'];
			$_SESSION['StudentName'] = $row['StudentName'];
			$_SESSION['SchoolEmailID'] = $row['EmailID'];
			$_SESSION['Qualification'] = $row['Qualification'];
			$_SESSION['EnrollmentStatus'] = $row['EnrollmentStatus'];
			$_SESSION['EnrollmentPeriod'] = $row['EnrollmentPeriod'];
			$_SESSION['Partner'] = $row['Partner'];
			$_SESSION['cohortCode'] = $row['cohortCode'];
			$_SESSION['Email'] = $user_email;
		}
	} else {
		$_SESSION['STUD_RECORD'] = 0;
		$_SESSION['STUD_ERR_MSG'] = "Student details not found! Please contact to support team members";
		header('Location: ./../landing.php');
	}
}

?>
<?php
echo "<br><br><br><br>";
if (isset($_SESSION['IsUpdatePassword']) && $_SESSION['IsUpdatePassword'] == '1') {
	header("Location: changepswd.php");
}
?>
<!DOCTYPE html>
<html xmlns:th="http://www.thymeleaf.org" xmlns:sec="http://www.thymeleaf.org/thymeleaf-extras-springsecurity5">

<head>
	<meta charset="UTF-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
	<title>Student Portal</title>
	<?php require('../portal/include/header.php'); ?>
	<style>
		thead {
			background-color: #b1036a;
			color: white;
		}

		table {
			text-align: center;
		}

		.table {
			margin-bottom: 0px;
		}

		td,
		th {
			/*width : 200px;
    		height:55px;*/
			font-size: 10pt;
			padding: 7px !important;
			vertical-align: middle;
		}

		a {
			text-decoration: none;
		}

		body {
			width: 100%;
		}

		.contentdata {
			background-color: #f3d4a0;
			color: black;
		}

		.text-left {
			text-align: left !important
		}

		.text-center {
			text-align: center !important
		}

		.text-right {
			text-align: right !important
		}

		.width-10 {
			width: 10% !important;
		}

		.width-12 {
			width: 12% !important;
		}

		.width-30 {
			width: 30% !important;
		}
	</style>

	<script>
		var prevAccord;

		function accordDetails(ele) {

			if (prevAccord != null && prevAccord != ele) {
				document.getElementById(prevAccord).style.display = "none";
				document.getElementById(ele).style.display = "block";
				prevAccord = ele;
			} else {
				if (prevAccord == ele && document.getElementById(prevAccord).style.display == "none") {
					document.getElementById(ele).style.display = "block";
				} else if (prevAccord == ele) {
					document.getElementById(ele).style.display = "none";
				} else {
					document.getElementById(ele).style.display = "block";
				}

			}
			prevAccord = ele;
		}
	</script>

</head>

<body>

	<div th:include="header2 :: copy"></div>
	<nav>
		<a class="logo"><img src="../assets/images/logo.jpeg"></a>
		<input class="menu-btn" type="checkbox" id="menu-btn" /> <label class="menu-icon" for="menu-btn"> <span class="nav-icon"></span>
		</label>


		<sec:authorize access="isAuthenticated()">

			<sec:authorize access="hasRole('STUD')">
				<ul class="menu" style="border-radius: 5px;">
					<li>
						<form action="user_logout.php" method="get" style="padding:7px;">
							<input type="submit" name="logout" value="logout" class="btn btn-primary"></input>
						</form>
					</li>
				</ul>
			</sec:authorize>
		</sec:authorize>
	</nav>

	<?php
	if (isset($_SESSION["change_password_msg"]) && !empty($_SESSION["change_password_msg"])) {
		echo $_SESSION["change_password_msg"];
		$_SESSION["change_password_msg"] = "";
	}
	?>

	<div style="padding: 0px 25px 50px;">
		<div class="row">
			<div class="col-md-2 col-sm-4">
				<img src="./images/avatar.png" alt="" style="width: 8rem; height: 8rem;" class="rounded-circle" />
			</div>
			<div class="col-md-9 col-sm-12">
				<div class="row">
					<div class="col-md-6 col-sm-12">
						<b> Name: </b> <br>
						<p>
							<?php echo $_SESSION['StudentName']; ?>
						</p>
					</div>
					<div class="col-md-5 col-sm-12">
						<b> Cohort: </b> <br>
						<p th:text="${userDetail.cohortCode}"><?php echo explode("-", $_SESSION['Qualification'])[0]; ?></p>
					</div>
				</div>
				<div class="row">
					<div class="col-md-6 col-sm-12">
						<b> Qualification: </b> <br>
						<p th:text="${userDetail.courseName}"><?php echo $_SESSION['Qualification']; ?></p>
					</div>
					<div class="col-md-5 col-sm-12">
						<b> Enrollment Period: </b> <br>
						<p th:text="${userDetail.courseCommencementDateString}"><?php echo $_SESSION['EnrollmentPeriod']; ?></p>
					</div>
					<div class="col-md-5 col-sm-12">
						<b> Partner: </b> <br>
						<p th:text="${userDetail.partner}"><?php echo $_SESSION['Partner']; ?></p>
					</div>
				</div>
			</div>
		</div>

		<?php
		$user_email = $_SESSION['SchoolEmailID'];

		mysqli_query($connection, "SET SQL_BIG_SELECTS = 1;");
		$partner_code = '';
		//$dataresult = mysqli_query($connection, "CALL SP_STUD_GetStudentDetail_v7('$user_email')");
		$dataresult = mysqli_query($connection, "CALL SP_STUD_GetStudentDetail_v8('" . $user_email . "', '" . $partner_code . "')");
		$datafromresults = [];
		while ($row = mysqli_fetch_assoc($dataresult)) {
			$datafromresults[] = $row;
		}
		?>

		<br />
		<h4 style="p-0">Completed Modules</h4>
		<table class="table table-hover">
			<thead>
				<tr>
					<th class="text-left width-10">No.</th>
					<th class="text-left width-30">Module Name</th>
					<th class="text-left width-12">Overall Attendance</th>
					<th class="text-left width-12">Commencement</th>
					<th class="text-left width-12">Completion</th>
					<th class="text-left width-12"> Assessment Eligibility</th>
					<th class="text-left width-12">Result Percentage</th>
					<th class="text-left width-12">Details</th>
				</tr>
			</thead>
		</table>

		<div th:each="comMod : ${completedMod}">
			<!--Module 1-->
			<?php
			$completed_module_count = 0;
			foreach ($datafromresults as $row) {
				$status_color = '';
				$assessment_eligibility = '';
				if ($row["ResultStatus"] == "Fail")
					$status_color = "bg-danger";
				else if ($row["ResultStatus"] == "Pass" || $row["ResultStatus"] == "Dist" || $row["ResultStatus"] == "Merit")
					$status_color = "bg-success";

				if ($row["IsMCQExist"] == 1 && $row["IsAssignmentExist"] == 1) {
					if ($row["CompletionStatus"] != "1") {
						if (
							$row["Att Rate(ToDate)"] >= $row["MinimumAttendancePercentage"] && $row["MCQScoreEarned"] > 0 && $row["MCQ_Status"] == "1" &&
							$row["AssignmentScoreEarned"] > 0 && $row["Assignment_Status"] == "1" && $row["SAPR_Status"] == "1"
						)
							$assessment_eligibility = "Eligible";
						else
							$assessment_eligibility = "Not Eligible";
					} else {
						if (
							$row["Att Rate(ToDate)"] >= $row["MinimumAttendancePercentage"] && $row["MCQScoreEarned"] > 0 && $row["MCQ_Status"] == "1" &&
							$row["AssignmentScoreEarned"] > 0 && $row["Assignment_Status"] == "1" &&
							$row["PRScore"] > 0  && $row["SAPR_Status"] == "1" && $row["PPScore"] > 0 && $row["SAPP_Status"] == "1"
						)
							$assessment_eligibility = "Pass";
						else
							$assessment_eligibility = "Fail";
					}
				} else {
					if ($row["CompletionStatus"] != "1") {
						if ($row["Att Rate(ToDate)"] >= $row["MinimumAttendancePercentage"] && $row["SAPR_Status"] == "1")
							$assessment_eligibility = "Eligible";
						else
							$assessment_eligibility = "Not Eligible";
					} else {
						if ($row["Att Rate(ToDate)"] >= $row["MinimumAttendancePercentage"] && $row["PRScore"] > 0  && $row["SAPR_Status"] == "1" && $row["PPScore"] > 0 && $row["SAPP_Status"] == "1")
							$assessment_eligibility = "Pass";
						else
							$assessment_eligibility = "Fail";
					}
				}

				if ($row["CompletionStatus"] != "1" && $row["PRScore"] == 0) {
					$assessment_eligibility = "In-progress";
				}
				if ($row['CompletionStatus'] == "1") {
					echo '<table class="table table-hover">';
					echo '<tbody>';
					echo '<tr>';
					echo '<td class="text-left width-10" th:text="${comMod.cohortCode}"><b>' . $row['enrollment_module_id'] . '</b></td>';
					echo '<td class="text-left width-30" th:text="${comMod.moduleName}">' . $row['Module Name'] . '<br>(' . $row['CohortCode'] . ')</td>';
					echo '<td class="text-left width-10">' . $row["Att Rate(ToDate)"] . ' %</td>';
					echo '<td class="text-center width-12">' . $row['Module Commencement Date'] . '</td>';
					echo '<td class="text-center width-12">' . $row['Module Completion Date'] . '</td>';
					echo '<td class="text-center width-12">' . $assessment_eligibility . '</td>';
					echo '<td class="text-center width-12">' . $row['OverallPercent'] . '
					<div>
					<span class="badge rounded-pill ' . $status_color . '" style="width:50px; margin-top: 2px;font-weight: 400;font-size: .8em; padding: 4px 0px 2px; ">' . $row["ResultStatus"] . '</span>
					</div>
					</td>';
					echo '<td class="text-right width-12">
					<input value="VIEW" type="button" class="btn btn-primary" 
					onclick=" if(document.getElementById(\'' . $completed_module_count . '_' . $row['enrollment_module_id'] . '\').style.display == \'none\')
					{
						getStudentGradeDetails(\'' . $row["Profile"] . '\',\'' . $row["School Email"] . '\', \'' . $row["CohortCode"] . '\', \'' . $completed_module_count . '_' . $row['enrollment_module_id'] . '\', \'' . $row["IsCustomGrade"] . '\');  
						document.getElementById(\'' . $completed_module_count . '_' . $row['enrollment_module_id'] . '\').style.display=\'block\';
					} 
					else 
					{ 
						document.getElementById(\'' . $completed_module_count . '_' . $row['enrollment_module_id'] . '\').style.display = \'none\'; 
					}">
					</td>';
					echo '</tr>';
					echo '</tbody>';
					echo '</table>';
					echo '<div id="' . $completed_module_count . '_' . $row['enrollment_module_id'] . '" style="display: none;margin-top:5px">';
					echo '</div>';
					$completed_module_count += 1;
				}
			}
			?>
		</div>

		<br />
		<h4 class="p-0">Ongoing Modules</h4>
		<table class="table table-hover">
			<thead>
				<tr>
					<th class="text-left width-10">No.</th>
					<th class="text-left width-30">Module Name</th>
					<th class="text-left width-12">Overall Attendance</th>
					<th class="text-left width-12">Commencement</th>
					<th class="text-left width-12">Completion</th>
					<!-- <th class="text-left width-12"> Assessment Eligibility</th> -->
					<th class="text-left width-12">Result Percentage</th>
					<th class="text-left width-12">Details</th>
				</tr>
			</thead>
		</table>
		<?php
		// var_dump($dataresult);
		$ongoing_module_count = 0;
		foreach ($datafromresults as $row) {
			$status_color = '';
			if ($row["ResultStatus"] == "Fail")
				$status_color = "bg-danger";
			else if ($row["ResultStatus"] == "Pass" || $row["ResultStatus"] == "Dist" || $row["ResultStatus"] == "Merit")
				$status_color = "bg-success";
			if ($row['CompletionStatus'] == "2") {
				echo '<table class="table table-hover">';
				echo '<tbody>';
				echo '<tr>';
				echo '<tbody th:each="ongoMod : ${ongoingMod}">';
				echo '<tr>';
				echo '<th class="text-left width-10">' . $row['enrollment_module_id'] . '</th>';
				echo '<td class="text-left width-30">' . $row['Module Name'] . '<br>(' . $row['CohortCode'] . ')</td>';
				echo '<td class="text-right width-12">' . $row["Att Rate(ToDate)"] . ' %</td>';
				echo '<td class="text-right width-12">' . $row['Module Commencement Date'] . '</td>';
				echo '<td class="text-right width-12">' . $row['Module Completion Date'] . '</td>';
				echo '<td class="text-right width-12">' . $row['OverallPercent'] . '
						<div>
						<span class="badge rounded-pill ' . $status_color . '" style="width:50px; margin-top: 2px;font-weight: 400;font-size: .8em; padding: 4px 0px 2px; ">' . $row["ResultStatus"] . '</span>
						</div>
						</td>';
				echo '<td class="text-right width-12">
				<input type="button" class="btn btn-primary" value="VIEW" 
				onclick=" if(document.getElementById(\'' . $ongoing_module_count . '_' . $row['enrollment_module_id'] . '\').style.display == \'none\')
				{
					getStudentGradeDetails(\'' . $row["Profile"] . '\',\'' . $row["School Email"] . '\', \'' . $row["CohortCode"] . '\', \'' . $ongoing_module_count . '_' . $row['enrollment_module_id'] . '\', \'' . $row["IsCustomGrade"] . '\');  
					document.getElementById(\'' . $ongoing_module_count . '_' . $row['enrollment_module_id'] . '\').style.display=\'block\';
				} 
				else 
				{ 
					document.getElementById(\'' . $ongoing_module_count . '_' . $row['enrollment_module_id'] . '\').style.display = \'none\';
				}">
				</td>';
				echo '</tr>';
				echo '</tbody>';
				echo '</table>';
				echo '<div id="' . $ongoing_module_count . '_' . $row['enrollment_module_id'] . '" style="display: none;margin-top:5px">';
				echo '</div>';
				$ongoing_module_count += 1;
			}
		}
		?>

		<!--Module 3 Details-->


		</tbody>
		</table>
		<br />
		<h4 class="p-0">Upcoming Modules</h4>
		<table class="table table-hover">
			<thead>
				<tr>
					<th class="text-left width-10">No.</th>
					<th class="text-left width-30">Module Name</th>
					<th class="text-left width-12">Overall Attendance</th>
					<th class="text-left width-12">Commencement</th>
					<th class="text-left width-12">Completion</th>
					<th class="text-left width-12"> Assessment Eligibility</th>
					<th class="text-left width-12">Result Percentage</th>
					<th class="text-left width-12">Details</th>
				</tr>
			</thead>
			<tbody>
				<?php
				// var_dump($dataresult);
				foreach ($datafromresults as $row) {
					if ($row['CompletionStatus'] == "3") {
						echo '<tr>';
						echo '<th th:text="${comMod.enrollmentModuleId}" style="text-align:left;">' . $row['enrollment_module_id'] . '</th>';
						echo '<td th:text="${comMod.cohortCode}" style="text-align:left;vertical-align: bottom;">' . $row['CohortCode'] . '</td>';
						echo '<td th:text="${comMod.cohortCode}" style="text-align:left;">' . explode("-", $row['CohortCode'])[0] . '</td>';
						echo '<td th:text="${comMod.moduleName}" style="text-align:left;">' . $row['Module Name'] . '</td>';
						echo '<td style="text-align:left;">' . $row['Module Commencement Date'] . '</td>';
						echo '<td style="text-align:left;">' . $row['Module Completion Date'] . '</td>';
						echo '<td></td>';
						echo '</tr>';
					}
				}
				?>

			</tbody>
		</table>
	</div>
	</div>
	<div th:fragment="copy">
		<footer class="container-fluid bg-4 text-center" style="position: fixed;bottom: 0;">
			<h4>&copy; <script>
					document.write(new Date().getFullYear())
				</script> Lithan - EduClaas.</h4>
		</footer>
	</div>
	<div th:include="footer :: copy"></div>


	<script>
		$(document).ready(function() {
			console.log("ready!");
		});

		function getStudentGradeDetails(profile_type_param, email_id_param, cohort_code_param, element_row_id_for_data_population, is_custom_grade_param) {
			$('#' + element_row_id_for_data_population).html('<div style="padding:20px; display: flex; justify-content: center; align-items: center;"><div  class="spinner-border center" role="status"><span class="sr-only">Loading...</span></div></div>');
			$.post("SP_GetStudentGradeDetail.php", {
					custom_grade: is_custom_grade_param,
					profile_type: String(profile_type_param),
					email_id: email_id_param,
					cohort_code: cohort_code_param
				})
				.done(function(data) {
					$('#' + element_row_id_for_data_population).html(data);
				});
		}
	</script>


</body>

</html>