<?php require "db_connect.php" ?>

<!DOCTYPE html>
<html xmlns:th="http://www.thymeleaf.org" xmlns:sec="http://www.thymeleaf.org/thymeleaf-extras-springsecurity5">

<head>
	<meta charset="UTF-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
	<title>Student Portal</title>
	<?php require('../portal/include/header.php'); ?>

	<style>
		thead {
			background-color: #b1036a;
			color: white;
		}

		table {
			text-align: center;
		}

		.table {
			margin-bottom: 0px;
		}

		td,
		th {
			/*width: 200px;
	height: 55px;*/
			padding: 10px !important;
		}

		a {
			text-decoration: none;
		}

		body {
			width: 100%;
		}

		.contentdata {
			background-color: #f3d4a0;
			color: black;
		}

		.text-left {
			text-align: left !important
		}

		.text-center {
			text-align: center !important
		}

		.text-right {
			text-align: right !important
		}

		.width-10 {
			width: 10% !important;
		}

		.width-12 {
			width: 12% !important;
		}

		.width-30 {
			width: 30% !important;
		}

		.badge {
			color: black;
		}
	</style>

	<script>
		function getUserData() {
			var user = document.getElementById("UserTypeSelection").value;

			window.location = "resetpassword.php?usercode=" + user;
		}
	</script>


</head>

<body>
	<div th:include="header2 :: copy"></div>
	<nav>
		<a class="logo"> <img src="../assets/images/logo.jpeg">
		</a> <input class="menu-btn" type="checkbox" id="menu-btn" /> <label class="menu-icon" for="menu-btn"> <span class="nav-icon"></span>
		</label>





		<sec:authorize access="isAuthenticated()">

			<sec:authorize access="hasRole('ADM')">
				<ul class="menu" style="border-radius: 5px;">
					<!-- <li><a href="">User Profile</a></li>							
					 <li><a href="users">User Management</a></li>  -->

					<!-- /logout must be a POST request, as csrf is enabled.
			        This ensures that log out requires a CSRF token and that a malicious user cannot forcibly log out your users.-->

					<li>
						<form action="user_logout.php" method="get" style="padding:7px;">
							<input type="submit" name="logout" value="logout" class="btn btn-primary"></input>
						</form>
					</li>
				</ul>
			</sec:authorize>
		</sec:authorize>
	</nav>

	<?php
	if (isset($_SESSION["reset_password_msg"]) && !empty($_SESSION["reset_password_msg"])) {
		echo $_SESSION["reset_password_msg"];
		$_SESSION["change_password_msg"] = "";
	}
	?>
	<br>
	<br>
	<br>

	<?php
	if ($_SERVER['REQUEST_METHOD'] == "GET" && isset($_GET["usercode"])) {
		$usercode = $_GET["usercode"];
		if ($usercode == "S") {
			$usercode = "STUD";
		} elseif ($usercode == "P") {
			$usercode = "PART";
		}

		$dataResults = mysqli_query($connection, "CALL SP_GetUserAccountDetail('$usercode')");

		$datafromresults  = [];
		while ($row = mysqli_fetch_assoc($dataResults)) {
			$datafromresults[] = $row;
		}
		// while(mysqli_next_result($connection)){;};

		// foreach($data_from_cohort_results as $item){
		// 	print_r($item);
		// }
	} else {
		$usercode = 'STUD';
		$dataresult = mysqli_query($connection, "CALL SP_GetUserAccountDetail('$usercode')");
		$datafromresults = [];
		while ($row = mysqli_fetch_assoc($dataresult)) {
			$datafromresults[] = $row;
		}
	}
	?>

	<div class="alert alert-success" style="font-size:15px; font-weight:bold; display:none; margin-left:25px; margin-right:25px">
		Your Password was changed successfully!
	</div>
	<div class="alert alert-danger" style="font-size:16px; font-weight:bold; display:none;margin-left:25px; margin-right:25px">
		Password reset has failed. Please try again.
	</div>



	<div style="display: flex; justify-content: space-between; align-items: center; padding: 25px;">
		<h4>User Account Details</h4>

		<div style="display: flex; align-items: center;">
			<span style="margin-right: 10px;">User Type:</span>
			<select id="UserTypeSelection" onchange="getUserData()" class="UserType_selector" style="padding: 5px;">
				<option disabled selected>Select User Type</option>
				<option value="S">Student</option>
				<option value="P">Partner</option>
			</select>
		</div>
	</div>

	<!-- <h4 style="p-25;padding-left: 20px;"> User Account Details </h4>

 <div class="col-lg-11" style="display:flex;justify-content: flex-end;">
			<span>User Type:</span> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
			<select id="UserTypeSelection" onchange="getUserData()" class="UserType_selector">
			<option disabled selected>Select User Type</option>
			<option value="STUD" >Student</option>
			<option value="PART" >Partner</option>
			</select>
		</div>
		<br> -->

	<div style="padding: 0px 25px 50px;">
		<div class="row">


			<!-- <table class="table table-hover">
			
		</table> -->

			<div th:each="comMod : ${completedMod}">
				<!--Module 1-->
				<?php
				$completed_module_count = 0;

				echo '<table class="table table-hover">';
				echo '<tbody>';
				echo '<thead>';
				echo '<tr>';
				echo '<th class="text-left width-30">Email ID</th>';
				echo '<th class="text-center width-30">Partner Code</th>';
				// echo '<th class="text-center width-30">User Type</th>';
				echo '<th class="text-center width-30">Is Password Updated</th>';
				echo '<th class="text-center width-30"></th>';

				echo '</tr>';
				echo '</thead>';
				foreach ($datafromresults as $row) {
					echo '<tr>';
					echo '<td class="text-left width-25" th:text="${comMod.cohortCode}"><b>' . $row['EmailID'] . '</b></td>';
					// echo '<td class="text-center width-25" th:text="${comMod.cohortCode}"><b>'.$row['PartnerCode'].'</b></td>';
					echo '<td class="text-center">';
					if ($row['PartnerCode'] !== null) {
						echo '<b>' . $row['PartnerCode'] . '</b>';
					} else {
						echo '-'; // Display "-" if PartnerCode is null
					}
					echo '</td>';
					// echo '<td class="text-center" th:text="${comMod.cohortCode}"><b>'.$row['UserType'].'</b></td>';

					echo '<td class="text-center">';
					if ($row['IsUpdatePassword'] == 0) {
						echo '<i class="fa-solid fa-check"></i>';
					} else {

						echo '<i class="fa-solid fa-xmark"></i>';
					}
					echo '</td>';
					echo '<td class="text-right width-12"><input value="RESET" type="button" class="btn btn-primary" onclick="resetPassword(' . $row['UserAccountDetailID'] . ', \'' . $row['UserType'] . '\', \'' . $row['EmailID'] . '\')"></td>';


					// echo '<td class="text-right width-12"><input value="RESET" type="button" class="btn btn-primary" onclick="resetPassword(' . $row['UserAccountDetailID'] . ', \'' . $row['UserType'] . '\')"></td>';
					echo '</tr>';
				}
				echo '</tbody>';
				echo '</table>';
				// echo '<div id="'. $completed_module_count . '_' .$row['EmailID']. '" style="display: none;margin-top:5px">';
				echo '</div>';
				// $completed_module_count += 1;


				?>

				<script>
					function resetPassword(accountDetailID, userType, emailID) {
						$.ajax({
							type: 'POST',
							url: 'resetpswd.php', // Change this to the actual PHP script that handles the stored procedure call
							data: {
								accountDetailID: accountDetailID,
								userType: userType,
							},
							success: function(response) {
								var successDiv = $('.alert-success');
								if (userType == 'STUD') {
									var successMessage = 'Password of ' + emailID + ' is reset to Pass1234 successfully';
								} else {

									var successMessage = 'Password of ' + emailID + ' is reset to P@ss1234 successfully';
								}

								// Set the message text and show the success message div
								successDiv.text(successMessage).show();

								// Hide the success message div after 3 seconds
								setTimeout(function() {
									successDiv.hide();
								}, 5000);
							},
							error: function(xhr, status, error) {
								// Handle the error here, if needed
								var errorDiv = $('.alert-danger');

								errorDiv.show();

								setTimeout(function() {
									errorDiv.hide();
								}, 5000);
							}
						});
					}
				</script>
			</div>


		</div>
	</div>



</body>

</html>