<?php require "db_connect.php" ?>

<!DOCTYPE html>
<html xmlns:th="http://www.thymeleaf.org" xmlns:sec="http://www.thymeleaf.org/thymeleaf-extras-springsecurity5">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <title>Student Portal</title>
  <!--Font Awesome
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.11.2/css/all.css" />
    Google Fonts Roboto
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" />
    Bootstrap
    <link rel="stylesheet" href="../style/bootstrap.css" />
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.0-beta1/dist/js/bootstrap.bundle.min.js" integrity="sha384-pprn3073KE6tl6bjs2QrFaJGz5/SUsLqktiwsUTF55Jfv3qYSDhgCecCxMW52nD2" crossorigin="anonymous"></script>
    Custom styles
    <script src="../style/js/script.js"></script>-->


  <!-- Include the Toastify JS -->


  <!-- Font Awesome -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet" />
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700&display=swap" rel="stylesheet" />
  <!-- MDB -->

  <link href="https://cdnjs.cloudflare.com/ajax/libs/mdb-ui-kit/4.3.0/mdb.min.css" rel="stylesheet" />
  <!-- MDB -->



  <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/mdb-ui-kit/4.3.0/mdb.min.js"></script>







  <!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js" integrity="sha512-VEd+nq25CkR676O+pLBnDW09R7VQX9Mdiij052gVCp5yVH3jGtH70Ho/UUv4mJDsEdTvqRCFZg0NKGiojGnUCw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script> -->

  <!-- Jquery -->
  <script src="https://code.jquery.com/jquery-3.6.4.min.js" integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8=" crossorigin="anonymous"></script>


  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.min.js"> </script>

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />

  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

  <link th:rel="stylesheet" th:href="@{/webjars/bootstrap/5.1.3/css/bootstrap.min.css} " />
  <link th:rel="stylesheet" th:href="@{/styles/style.css} " />

  <link href="scripts/jquery-toast-plugin/toastr.min.css" rel="stylesheet" />






  <style>
    .modal {
      padding-top: 0px;
    }

    .modal-content {

      margin: 0px;
    }

    select {
      font-size: 28px;
    }

    .modal-dialog {
      max-width: 100%;
    }

    .modal-dialog-slideout {
      min-height: 100%;
      margin: 0 0 0 auto;
      background: #fff;
    }

    .modal.fade .modal-dialog.modal-dialog-slideout {
      -webkit-transform: translate(100%, 0)scale(1);
      transform: translate(100%, 0)scale(1);
    }

    .modal.fade.show .modal-dialog.modal-dialog-slideout {
      -webkit-transform: translate(0, 0);
      transform: translate(0, 0);
      display: flex;
      align-items: stretch;
      -webkit-box-align: stretch;
      height: 100%;
    }

    .modal.fade.show .modal-dialog.modal-dialog-slideout .modal-body {
      overflow-y: auto;
      overflow-x: hidden;
    }

    .modal-dialog-slideout .modal-content {
      border: 0;
    }

    .modal-dialog-slideout .modal-header,
    .modal-dialog-slideout .modal-footer {
      height: 4rem;
      display: block;
    }

    .DD {
      display: flex;
      align-items: center;
      justify-content: center;
      /* Optionally, to center horizontally */

    }

    thead {
      /* background-color: #b1036a; */
      background-color: lightgrey;
      color: black;
    }

    table {
      text-align: center;
    }

    .table {
      margin-bottom: 0px;
    }

    td {
      /*width: 200px;
	height: 55px;*/
      padding: 10px !important;
      border: 1px solid lightgrey;

    }

    th {
      padding: 10px !important;
      border: 1px solid grey;
    }

    a {
      text-decoration: none;
    }

    body {
      width: 100%;
    }

    .contentdata {
      background-color: #f3d4a0;
      color: black;
    }

    .text-left {
      text-align: left !important
    }

    .text-center {
      text-align: center !important
    }

    .text-right {
      text-align: right !important
    }

    .width-10 {
      width: 10% !important;
    }

    .width-12 {
      width: 12% !important;
    }

    .width-30 {
      width: 30% !important;
    }

    .badge {
      color: black;
    }

    .error {
      color: red;
    }

    .toast-red {
      background-color: red;
      color: white;
      /* You can change the text color if needed */
    }

    .custom-textbox {
      height: 42px;
      width: 100%;
      font-size: 14px;
    }

    input[type=text],
    input[type=password] {
      padding-top: 4px;
      padding-bottom: 3.28px;
    }

    .btn {
      box-shadow: 0px 0px 0px 0px;
    }

    .submit {
      background-color: red;
    }
  </style>
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

</head>

<body>



  <div th:include="header2 :: copy"></div>
  <nav>
    <a class="logo"> <img src="../assets/images/logo.jpeg">
    </a> <input class="menu-btn" type="checkbox" id="menu-btn" /> <label class="menu-icon" for="menu-btn"> <span class="nav-icon"></span>
    </label>

    <sec:authorize access="isAuthenticated()">

      <sec:authorize access="hasRole('ADM')">
        <ul class="menu" style="border-radius: 5px;">
          <!-- <li><a href="">User Profile</a></li>							
					 <li><a href="users">User Management</a></li>  -->

          <li>
            <form action="SearchByCohortCode.php" method="get" style="padding:7px;">
              <input type="submit" name="QualificationModule" value="Back To Search Page" class="btn btn-primary" style="background-color:#972162;" />
            </form>
          </li>

          <!-- /logout must be a POST request, as csrf is enabled.
			        This ensures that log out requires a CSRF token and that a malicious user cannot forcibly log out your users.-->

          <li>
            <form action="user_logout.php" method="get" style="padding:7px;">
              <input type="submit" name="logout" value="logout" class="btn btn-primary" style="background-color:white; color:#972162; border:1px solid #972162;"></input>
            </form>
          </li>
        </ul>
      </sec:authorize>
    </sec:authorize>
  </nav>

  <?php
  if (isset($_SESSION["reset_password_msg"]) && !empty($_SESSION["reset_password_msg"])) {
    echo $_SESSION["reset_password_msg"];
    $_SESSION["change_password_msg"] = "";
  }
  ?>
  <br>
  <br>
  <br>

  <?php
  if ($_SERVER['REQUEST_METHOD'] == "GET") {
    $dataResults = mysqli_query($connection, "CALL SP_ADM_GetQualificationModuleDetail_v1");

    $datafromresults  = [];
    while ($row = mysqli_fetch_assoc($dataResults)) {
      $datafromresults[] = $row;
    }
  }

  ?>

  <!-- This is Toaster popup before delete -->
  <div class="position-fixed top-50 start-50 translate-middle" style="z-index: 11">
    <input id="tempid" type="button" class="btn btn-primary" style="display:none">
    <div id="liveToast" class="toast hide" role="alert" aria-live="assertive" aria-atomic="true">
      <div class="toast-header">
        <strong class="me-auto">Do you want to Delete this?</strong>
      </div>
      <div class="toast-body">

        <ul style="list-style: none; padding: 0;">
          <li style="display: inline;">
            <input value="Yes" type="button" class="btn btn-primary" onclick="DeleteConfigDetails()">
          </li>
          <li style="display: inline;">
            <input value="No" type="button" class="btn btn-danger" onclick="CloseWarning()">
          </li>
        </ul>

      </div>
    </div>
  </div>
  <!-- End of Code -->

  <div style="display: flex; justify-content: space-between; align-items: center; padding: 25px;">
    <h4>Summative Assessment Grade detail</h4>
    <div style="display: flex; align-items: center;">
      <?php
      echo '<button type="button" class="btn btn-primary" style="background-color:#972162" onclick="openModal()">ADD QUALIFICATION & MODULE DETAILS</button>';
      ?>
      <!-- <button type="button" class="btn btn-primary">Add</button> -->
    </div>
  </div>



  <!-- This Modal is for insert -->
  <div class="modal fade" id="mdlCourseDetail" role="dialog" aria-labelledby="exampleModalLabel2" aria-hidden="true" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-dialog-slideout" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Add Qualification & Module detail</h5>

        </div>
        <div class="modal-body">
          <form id="frmQualificationModule">
            <div class="form-group row mb-3">
              <label for="QualificationCode" class="col-sm-3 col-form-label"><strong>Qualification Code :</strong></label>
              <div class="col-sm-8">
                <input type="qualification" name="qualificationCode" class="form-control" id="qualificationCode" placeholder="Enter the Qualification Code" autocomplete="off" required>
              </div>
            </div>

            <div class="form-group row">
              <label for="ModuleCode" class="col-sm-3 col-form-label"><strong>Module Code :</strong></label>
              <div class="col-sm-8">
                <input type="module" name="moduleCode" class="form-control" id="modulecode" placeholder="Enter the Module Code" autocomplete="off" required>
              </div>
          </form>
        </div>

      </div>
      <div class="modal-footer text-right">
        <!-- <button type="button" class="btn btn-primary">Submit</button> -->
        <input value="Submit" type="button" class="btn btn-primary" onclick="InsertQualificatiDetail()" style="background-color: #972162;">
        <input value="Close" type="button" class="btn btn-secondary" style="background-color:white; color:#972162; border:1px solid #972162;" data-dismiss="modal" onclick="closeModal()">
      </div>
    </div>
  </div>
  </div>
  <!-- End of Code -->

  <!-- This Modal is for update -->
  <div class="modal fade" id="mdlAssessmentGradeDetail" role="dialog" aria-labelledby="exampleModalLabel2" aria-hidden="true" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-dialog-slideout" role="document">
      <div class="modal-content">
        <div class="modal-header">

          <h5 class="modal-title">Add Passing Weighted Percentage</h5>

        </div>
        <div class="modal-body">
          <input type="hidden" class="form-control" id="txtQualificationModuleID">

          <div class="text-right">
            <input type="button" value="Add New Row" class="btn btn-primary list_add mb-3" id="btnAddNewRow" style="background-color:#972162;">
          </div>
          <div style="overflow-x:auto;">
            <div class="wrapper">
              <table class="table table-responsive-lg table-bordered table-striped" id="tblConfigMinimumGrade">
                <thead>
                  <tr class="" style="background-color: lightgrey; color: black; width: 100%;">
                    <!-- <th class="" width="10%"><i class="fas fa-times"></i></th> -->
                    <th class="" width="30%">Assessment Category Naming (Old)</th>
                    <th class="" width="30%">Assessment Category Naming (New)</th>
                    <th class="" width="30%">Passing Weightage %</th>
                  </tr>
                </thead>
                <tbody id="tbodyConfigMinimumGrade">
                </tbody>
              </table>


              <table id="tblRowNewTemplate">
                <tbody>
                  <tr class="template_row" id="tr{{RowIndex}}" style="display:none">
                    <!-- <td>
                          <i class="fas fa-trash" style="align-item:center; color:red"></i>
                        </td> -->
                    <td>
                      <!-- <input class="m-0 form-control m-input" type="text" id="ddlOldAssessmentType{{RowIndex}}" name="ddlOldAssessmentType{{RowIndex}}" placeholder="Enter old Assessment Type"> -->
                      <select class="m-0 form-control ddlOldAssessmentType" id="ddlOldAssessmentType{{RowIndex}}" name="ddlOldAssessmentType{{RowIndex}}"></select>
                    </td>
                    <td style="margin-top:auto; margin-bottom:auto">
                      <div class="DD">
                        <select class="m-0 form-control m-select2" id="ddlNewAssessmentType{{RowIndex}}" name="ddlNewAssessmentType{{RowIndex}}">
                          <option value="" selected="selected"> -- Select assessment type -- </option>
                          <option value="SA-MCQ">SA-MCQ</option>
                          <option value="SA-PR">SA-PR</option>
                          <option value="SA-PP">SA-PP</option>
                          <option value="SA-R-MCQ">SA-R-MCQ</option>
                          <option value="SA-R-PR">SA-R-PR</option>
                          <option value="SA-R-PP">SA-R-PP</option>
                        </select>
                      </div>
                    </td>
                    <td>
                      <input class="m-0 form-control m-input" type="text" id="txtMinimumGrade{{RowIndex}}"" name=" txtMinimumGrade{{RowIn dex}}" placeholder="Enter the Passing Weightage %">
                    </td>
                  </tr>
                </tbody>
              </table>

            </div>

          </div>
        </div>
        <div class="modal-footer text-right">
          <input value="Submit" type="button" class="btn btn-primary" onclick="InsertUpdateAssessmentGradeDetail()" style="background-color: #972162;">
          <input value="Close" type="button" class="btn btn-secondary" style="background-color:white; color:#972162; border:1px solid #972162;" data-dismiss="modal" onclick="closeModal()">
        </div>
      </div>

    </div>
  </div>
  </div>

  <div style="padding: 0px 25px 50px;">
    <div class="row">


      <!-- <table class="table table-hover">
			
		</table> -->

      <div th:each="comMod : ${completedMod}">
        <!--Module 1-->
        <?php
        $completed_module_count = 0;

        echo '<table class="table table-hover">';
        echo '<tbody>';
        echo '<thead>';
        echo '<tr>';
        echo '<th class="text-left width-30">Qualification Code</th>';
        echo '<th class="text-left width-30">ModuleCode</th>';
        echo '<th class="text-right width-30">Action</th>';

        echo '</tr>';
        echo '</thead>';

        foreach ($datafromresults as $row) {
          echo '<tr>';
          echo '<td class="text-left width-30" th:text="${comMod.cohortCode}"><b>' . $row['QualificationCode'] . '</b></td>';
          echo '<td class="text-left width-30" th:text="${comMod.cohortCode}"><b>' . $row['ModuleCode'] . '</b></td>';
          echo '<td class="text-right width-30">
                                    <i class="fa-solid fa-pen-to-square" style="color: #972162; font-size:20px;" onclick="OpenUpdateModal(\'' . $row['QualificationModuleID'] . '\',\'' . $row['QualificationCode'] . '\',\'' . $row['ModuleCode'] . '\')"></i>
                                   
                                    
                                  </td>';


          echo '</tr>';
        }

        echo '</tbody>';
        echo '</table>';
        // echo '<div id="'. $completed_module_count . '_' .$row['EmailID']. '" style="display: none;margin-top:5px">';
        echo '</div>';
        // $completed_module_count += 1;


        ?>


        <script type="text/javascript" src="scripts/jquery-toast-plugin/toastr.min.js"></script>
        <script src="scripts/qualificationmodule.js"></script>
      </div>





    </div>


  </div>
  </div>

  <div style="z-index:10;">
    <div id="loader" style="display:flex; align-items:center; justify-content:center; position:absolute; width:100%; margin-top: -10%; display:none">
      <div class="spinner-border text-danger" role="status">
      </div>
    </div>



</body>

</html>