<?php
require "db_connect.php";
require __DIR__ . "/../global_variable.php";
// Start the session
session_start();

if (!isset($_SESSION["msatg"])) {
	header("Location:" . $redirectUrl);
}
echo "<br><br><br><br>";
if (isset($IsUpdatePassword) && $_SESSION["IsUpdatePassword"] == "1") {
	header("Location: changepswd.php");
}
?>

<!DOCTYPE html>
<html xmlns:th="http://www.thymeleaf.org">

<head>
	<title>Partner Portal</title>
	<?php require "../portal/include/header.php"; ?>
	<style>
		thead {
			background-color: #b1036a;
			color: white;
		}

		table {
			text-align: center;
		}

		.table {
			margin-bottom: 0px;
		}

		td,
		th {
			/*width : 200px;
    			height:55px;*/
			font-size: 10pt;
			padding: 7px !important;
			vertical-align: middle;
		}

		a {
			text-decoration: none;
		}

		body {
			width: 100%;
		}

		.contentdata {
			background-color: #f3d4a0;
			color: black;
		}

		.all {
			padding: 0px 25px 50px;
		}

		.text-left {
			text-align: left !important;
		}

		.text-center {
			text-align: center !important;
		}

		.text-right {
			text-align: right !important;
		}

		.width-10 {
			width: 10% !important;
		}

		.width-12 {
			width: 12% !important;
		}

		.width-15 {
			width: 15% !important;
		}

		.width-20 {
			width: 20% !important;
		}


		.width-25 {
			width: 25% !important;
		}

		.width-30 {
			width: 30% !important;
		}



		.badge {
			color: white;
		}
	</style>

	<script>
		var prevAccord;

		function accordDetails(ele) {

			if (prevAccord != null && prevAccord != ele) {
				document.getElementById(prevAccord).style.display = "none";
				document.getElementById(ele).style.display = "block";
				prevAccord = ele;
			} else {
				if (prevAccord == ele && document.getElementById(prevAccord).style.display == "none") {
					document.getElementById(ele).style.display = "block";
				} else if (prevAccord == ele) {
					document.getElementById(ele).style.display = "none";
				} else {
					document.getElementById(ele).style.display = "block";
				}

			}
			prevAccord = ele;
		}


		function getCohortData() {
			var cohort = document.getElementById("cohortSelection").value;
			cohort = encodeURIComponent(cohort.split('_')[0]) + "_" + cohort.split('_')[1];
			window.location = "partnerportal.php?cohortCode=" + cohort;
		}
	</script>

</head>

<body>
	<nav>
		<a class="logo"> <img src="../assets/images/logo.jpeg">
		</a> <input class="menu-btn" type="checkbox" id="menu-btn" /> <label class="menu-icon" for="menu-btn"> <span class="nav-icon"></span>
		</label>


		<sec:authorize access="isAuthenticated()">

			<sec:authorize access="hasRole('STUD')">
				<ul class="menu" style="border-radius: 5px;">
					<!-- <li><a href="">User Profile</a></li>							
					 <li><a href="users">User Management</a></li>  -->

					<!-- /logout must be a POST request, as csrf is enabled.
			        This ensures that log out requires a CSRF token and that a malicious user cannot forcibly log out your users.-->

					<li>
						<form action="user_logout.php" method="get" style="padding:7px;">
							<input type="submit" name="logout" value="logout" class="btn btn-primary" style="background-color:white; color:#972162; border:1px solid #972162; box-shadow:0px 0px 0px 0px;" />
						</form>
					</li>
				</ul>
			</sec:authorize>
		</sec:authorize>
	</nav>

	<?php if (
		isset($_SESSION["change_password_msg"]) &&
		!empty($_SESSION["change_password_msg"])
	) {
		echo $_SESSION["change_password_msg"];
		$_SESSION["change_password_msg"] = "";
	} ?>
	<div style="padding: 0px 25px 50px;">
		<div class="col-md-12 row">
			<?php
			$data_from_cohort_results = [];
			if ($_SERVER["REQUEST_METHOD"] == "GET" && isset($_GET["cohortCode"])) {
				$cohortResults = mysqli_query(
					$connection,
					"CALL SP_GetModuleDetailForPartner('" .
						urldecode(explode("_", $_GET["cohortCode"])[0]) .
						"', '" .
						explode("_", $_GET["cohortCode"])[1] .
						"' , '" .
						$_SESSION["PartnerInformation"] .
						"')"
				);

				// print_r(explode("_", $_GET["cohortCode"]));

				//var_dump($cohortResults);
				// print($_GET["cohortCode"]);
				//echo "<br> " . $_SESSION["partner_code"];

				$data_from_cohort_results = [];
				while ($row = mysqli_fetch_assoc($cohortResults)) {
					$data_from_cohort_results[] = $row;
					//print_r($row);
				}

				while (mysqli_next_result($connection)) {
				}

				// foreach($data_from_cohort_results as $item){
				// 	print_r($item);
				// }
			}
			?>
			<div class="d-flex align-items-center justify-content-center">
				<div class="col-md-4 p-0">
					<label>Partner name:</label> <b><?php echo $_SESSION["PartnerInformation"]; ?></b> <br>
				</div>
				<div class="col-md-2 text-center d-flex align-items-center gap-4 ">
					<div class="d-flex gap-1">
						<input type="radio" id="rdCourse" name="searchType" checked onclick="toggleSearchSection('course')">
						<label for="rdCourse">Course</label>
					</div>
					<div class="d-flex gap-1">
						<input type="radio" id="rdEmailID" name="searchType" onclick="toggleSearchSection('email')">
						<label for="rdEmailID">Email ID</label>
					</div>
				</div>
				<div class="col-md-6 d-none" id="dvSearchByEmailID">
					<input style="flex: 1; margin-right: 10px;" type="email" id="txtEmailID" name="txtEmailID" class="form-control" required />
					<input type="button" value="Search by Email" class="btn btn-primary" style="background-color: #972162; margin-left: 5px; padding: 8px 15px;" onclick="getStudentDataByEmailID()">
				</div>
				<div class="col-md-6" style="" id="dvSearchByCourse">
					<select id="cohortSelection" onchange="getCohortData()" class="cohort_selector">
						<option> -- Select Course -- </option>
						<?php
						$partner_code = $_SESSION["PartnerInformation"];
						$profile_type = $_SESSION["UserType"];
						$dataresult = mysqli_query($connection, "CALL SP_GetCourseDetailByPartner('" . $partner_code . "', '" . $profile_type . "')");


						$datafromresults = [];

						while ($row = mysqli_fetch_assoc($dataresult)) {
							$datafromresults[] = $row;
						}

						while (mysqli_next_result($connection)) {
						}

						foreach ($datafromresults as $item) {
							echo '<option class="dropdown-item" value="' .
								$item["VALUE"] .
								'">' .
								$item["TEXT"] .
								"</option>";
						}
						?>

					</select>
				</div>
			</div>
		</div>

		<br>
		<div id="coursedata">
			<div class="shadow-sm">
				<div class="row">
					<h4 class="p-0">Completed Module</h4>
					<!-- loop through each course here for complete module-->
					<table class="table-responsive">
						<thead>
							<tr>
								<!-- <th>S.No</th> -->
								<th class="text-left width-25">Cohort Code</th>
								<th class="text-left width-30">Module Name</th>
								<th class="text-right width-15">Commencement</th>
								<th class="text-right width-15">Completion</th>
								<th class="text-right width-15">Details</th>
							</tr>
						</thead>
					</table>
				</div>

				<div th:each="chrtComModDetail : ${cohortComModDetail}">
					<div class="row">

						<?php
						$completed_module_count = 0;
						try {
							if ($data_from_cohort_results != null) {
								foreach ($data_from_cohort_results as $item) {
									if ($item["CompletionStatus"] == "1") {
										echo '	<table class="table table-hover table-responsive" style="width:100%;">';
										echo "	<tbody>";
										echo "<tr>";
										echo '	<td class="text-left width-25" th:text="${chrtComModDetail.cohortCode}"">' .
											$item["CohortCode"] .
											"</td>";
										echo '	<td class="text-left width-30" th:text="${chrtComModDetail.moduleName}">' .
											$item["Module Name"] .
											"</td>";
										echo '	<td class="text-right width-15" th:text="${chrtComModDetail.moduleCommencementDateString}">' .
											$item["Module Commencement Date"] .
											"</td>";
										echo '	<td class="text-right width-15" th:text="${chrtComModDetail.moduleCompletionDateString}">' .
											$item["Module Completion Date"] .
											"</td>";
										echo '	<td class="text-right width-15"><input type="button" value="VIEW" class="btn btn-primary" onclick=" if(document.getElementById(\'' .
											$completed_module_count .
											"_" .
											$item["CohortCode"] .
											'\').style.display == \'none\'){getStudentGradeDetails(\'' .
											$_SESSION["PartnerInformation"] .
											'\', \'' .
											$item["CohortCode"] .
											'\', \'' .
											$_GET["cohortCode"] .
											'\', \'' .
											$completed_module_count .
											"_" .
											$item["CohortCode"] .
											'\');  document.getElementById(\'' .
											$completed_module_count .
											"_" .
											$item["CohortCode"] .
											'\').style.display=\'block\'; } else { document.getElementById(\'' .
											$completed_module_count .
											"_" .
											$item["CohortCode"] .
											'\').style.display = \'none\';}"></td>';
										echo "</tr>";
										echo "</tbody>";
										echo "</table>";
										echo '<div id="' .
											$completed_module_count .
											"_" .
											$item["CohortCode"] .
											'" style="display: none;margin-top:5px">';
										echo "</div>";
										$completed_module_count += 1;
									}
								}
							} else {
								echo "<div align='center'>Please Select Course Type</div>";
							}
						} catch (Exception $e) {
							// do nothing for now
						}
						?>
					</div>

					<div class="row px-5">
						<div th:id="${chrtComModDetail.cohortCode}" style="display:none">
							<table class="table shadow">
								<thead class="contentdata">
									<tr>
										<th>Name</th>
										<th>Attendance</th>
										<th>SA-MCQ</th>
										<th>SA-Knowledge</th>
										<th>SA-Presentation</th>
										<th>Total</th>
										<th>Assessment</th>
										<th>Result</th>
										<th>Remarks</th>
									</tr>
								</thead>
								<tbody>
							</table>
							<table th:each="cohortComMod : ${cohortCompletedMod}">
								<tr th:if="${cohortComMod.cohortCode == chrtComModDetail.cohortCode}">

									<td th:text="${cohortComMod.name}"></td>
									<td th:text="${cohortComMod.attRateFull}"></td>
									<td>20</td>
									<td>20</td>
									<td>20</td>
									<td>75</td>
									<td th:text="${cohortComMod.learnerAssessmentDateString}"></td>
									<td th:text="${cohortComMod.result}"></td>
									<td>Good Job</td>


								</tr>

								</tbody>
							</table>
							<br>
							<br>
						</div>
					</div>
				</div>
			</div>
			<!-- ------------------------------------------------------- -->

			<!-- end of complete module loop -->

			<br>

			<!-- loop through each course here for ongoing module-->
			<div class="shadow-sm">
				<div class="row">
					<h4 class="p-0">Ongoing Module</h4>
					<table class="table table-hover">
						<thead>
							<tr>
								<th class="text-left width-25">Cohort Code</th>
								<th class="text-left width-30">Module Name</th>
								<th class="text-right width-15">Commencement</th>
								<th class="text-right width-15">Completion</th>
								<th class="text-right width-15">Details</th>
							</tr>
						</thead>
					</table>
				</div>

				<div th:each="chrtOngModDetail :${cohortOngModDetail }">
					<div class="row">
						<?php
						$ongoing_module_count = 0;
						try {
							if ($data_from_cohort_results != null) {
								foreach ($data_from_cohort_results as $item) {
									if ($item["CompletionStatus"] == "2") {
										echo '<table class="table table-hover" style="width:100%";>';
										echo "	<tbody>";
										echo "<tr>";
										echo '	<td class="text-left width-25" th:text="${chrtComModDetail.cohortCode}">' .
											$item["CohortCode"] .
											"</td>";
										echo '	<td class="text-left width-30" th:text="${chrtComModDetail.moduleName}">' .
											$item["Module Name"] .
											"</td>";
										echo '	<td class="text-right width-15" th:text="${chrtComModDetail.moduleCommencementDateString}">' .
											$item["Module Commencement Date"] .
											"</td>";
										echo '	<td class="text-right width-15" th:text="${chrtComModDetail.moduleCompletionDateString}">' .
											$item["Module Completion Date"] .
											"</td>";
										echo '	<td class="text-right width-15">
									<input type="button" value="VIEW" class="btn btn-primary"  
									onclick=" if(document.getElementById(\'' .
											$ongoing_module_count .
											"_" .
											$item["CohortCode"] .
											'\').style.display == \'none\')
									{
										getStudentGradeDetails(\'' .
											$_SESSION["PartnerInformation"] .
											'\', \'' .
											$item["CohortCode"] .
											'\', \'' .
											$_GET["cohortCode"] .
											'\', \'' .
											$ongoing_module_count .
											"_" .
											$item["CohortCode"] .
											'\');  
										document.getElementById(\'' .
											$ongoing_module_count .
											"_" .
											$item["CohortCode"] .
											'\').style.display=\'block\';
									} 
									else { 
										document.getElementById(\'' .
											$ongoing_module_count .
											"_" .
											$item["CohortCode"] .
											'\').style.display = \'none\';
									}">
									</td>';
										echo "</tr>";
										echo "</tbody>";
										echo "</table>";
										echo '<div id="' .
											$ongoing_module_count .
											"_" .
											$item["CohortCode"] .
											'" style="display: none;margin-top:5px">';
										echo "</div>";
										$ongoing_module_count += 1;
									}
								}
							} else {
								echo "<div align='center'>Please Select Course Type</div>";
							}
						} catch (Exception $e) {
						}
						?>
					</div>


					<div class="row px-5">
						<div th:id="${chrtOngModDetail.cohortCode}" style="display:none">
							<table class="table shadow">
								<thead class="contentdata">
									<tr>
										<th rowspan="2">Name</th>
										<th rowspan="2" width="50px">Attendance</th>
										<th colspan="10">MCQ</th>
										<th colspan="3">Assingnment</th>
										<th colspan="3">Summative</th>
										<!-- <th rowspan="2">Total</th>
						<th rowspan="2">Eligibility</th>-->
									</tr>
									<tr>
										<th>1</th>
										<th>2</th>
										<th>3</th>
										<th>4</th>
										<th>5</th>
										<th>6</th>
										<th>7</th>
										<th>8</th>
										<th>9</th>
										<th>10</th>
										<th>A1</th>
										<th>A2</th>
										<th>A3</th>
										<th>Report</th>
										<th>PPT</th>
										<th>Code</th>
									</tr>
								</thead>
							</table>
							<table>
								<tr th:each="chrtOngMod :${cohortOngoingModule}" th:if="${chrtOngModDetail.cohortCode} == ${chrtOngMod.cohortCode}">
									<td th:text="${chrtOngMod.name}">john</td>
									<td th:text="${chrtOngMod.attRateFull}">56</td>
									<td>20</td>
									<td>20</td>
									<td>20</td>
									<td>15</td>
									<td>75</td>
									<td>20</td>
									<td>20</td>
									<td>20</td>
									<td>15</td>
									<td>75</td>
									<td>70</td>
									<td>80</td>
									<td><span class="badge bg-danger">N.S</span></td>
									<td><span class="badge bg-danger">N.S</span></td>
									<td><span class="badge bg-warning">N.G</span></td>
									<td><span class="badge bg-danger">N.S</span></td>
									<td>50%</td>
								</tr>
							</table>
							<br>
						</div>
					</div>
				</div>
			</div>
			<!-- end of ongoing module loop -->
			<br>
			<!-- loop through each course here for upcoming module-->
			<div class="row shadow-sm">
				<h4 class="p-0">Upcoming Modules</h4>
				<table class="table">
					<thead>
						<tr>
							<th class="text-left width-25">Cohort Code</th>
							<th class="text-left width-30">Module Name</th>
							<th class="text-right width-15">Commencement</th>
							<th class="text-right width-15">Completion</th>
							<th class="text-right width-15">Details</th>
						</tr>
					</thead>
				</table>
				<?php try {
					if ($data_from_cohort_results != null) {
						foreach ($data_from_cohort_results as $item) {
							if ($item["CompletionStatus"] == "3") {
								echo "<table>";
								echo "<tr>";
								echo '<td class="text-left width-25" th:text="${chrtComModDetail.cohortCode}">' .
									$item["CohortCode"] .
									"</td>";
								echo '<td class="text-left width-30" th:text="${chrtComModDetail.moduleName}">' .
									$item["Module Name"] .
									"</td>";
								echo '<td class="text-right width-15" th:text="${chrtComModDetail.moduleCommencementDateString}">' .
									$item["Module Commencement Date"] .
									"</td>";
								echo '<td class="text-right width-15" th:text="${chrtComModDetail.moduleCompletionDateString}">' .
									$item["Module Completion Date"] .
									"</td>";
								echo '<td class="text-right width-15">&nbsp;</td>';
								echo "</tr>";
								echo "</table>";
							}
						}
					} else {
						echo "<tr><div align='center'>Please Select Course Type</div></tr>";
					}
				} catch (Exception $e) {
				} ?>



				<!-- end of upcoming module loop -->

			</div>
		</div>

		<div class="row" style="margin-bottom:40px" id="tdGetDetailByEmailID">
			<div id="dvShowStudentDetailByEmailID" style="padding:0px">
				<!-- Student profile detail will be shown here -->
			</div>
		</div>
	</div>

	<div th:fragment="copy">
		<footer class="container-fluid bg-4 text-center">
			<h5>&copy; <script>
					document.write(new Date().getFullYear())
				</script> Lithan - EduClaas.</h5>
		</footer>
	</div>


	<script>
		$(document).ready(function() {
			console.log("ready!");
		});

		function getStudentGradeDetails(profile_type_param, cohort_code_param, cohort_code_full_param, element_row_id_for_data_population) {
			$('#' + element_row_id_for_data_population).html('<div style="padding:20px; display: flex; justify-content: center; align-items: center;"><div  class="spinner-border center" role="status"><span class="sr-only">Loading...</span></div></div>');
			$.post("SP_GetStudentDetailForPartner.php", {
					profile_type: String(profile_type_param),
					cohort_code: cohort_code_param,
					cohort_code_full: cohort_code_full_param
				})
				.done(function(data) {
					$('#' + element_row_id_for_data_population).html(data);
				});
		}



		function getPartenerDetails(profile_type_param, user_id_param, cohort_code_param, element_row_id_for_data_population, is_custom_grade_param, email_id_param) {
			$('#' + element_row_id_for_data_population).html('<div style="padding:20px; display: flex; justify-content: center; align-items: center;"><div  class="spinner-border center" role="status"><span class="sr-only">Loading...</span></div></div>');
			$.post("SP_GetGradeDetailForPartner.php", {
					custom_grade: is_custom_grade_param,
					email_id: email_id_param,
					profile_type: String(profile_type_param),
					user_id: user_id_param,
					cohort_code: cohort_code_param
				})
				.done(function(data) {
					$('#' + element_row_id_for_data_population).html(data);
				});
		}
	</script>
	<script>
		function toggleSearchSection(type) {
			if (type === 'course') {
				$('#dvSearchByCourse').removeClass('d-none');
				$('#dvSearchByCourse').addClass('d-flex');

				$('#dvSearchByEmailID').removeClass('d-flex');
				$('#dvSearchByEmailID').addClass('d-none');
				$('#coursedata').show();
			} else if (type === 'email') {
				console.log(type, "type");
				$('#dvSearchByCourse').removeClass('d-flex');
				$('#dvSearchByCourse').addClass('d-none');

				$('#dvSearchByEmailID').removeClass('d-none');
				$('#dvSearchByEmailID').addClass('d-flex');
				//$('#coursedata').hide();
				//	$('#dvShowStudentDetailByEmailID').show();


			}
		}

		function getStudentDataByEmailID() {

			if ($('#txtEmailID').val() != null && $('#txtEmailID').val() != '') {
				$('#tdGetDetailByEmailID').show();
				$('#coursedata').hide();
				$('#dvShowStudentDetailByEmailID').html('<div style="padding:20px; display: flex; justify-content: center; align-items: center;"><div  class="spinner-border center" role="status"><span class="sr-only">Loading...</span></div></div>');
				$.post("GetStudentDetailByEmailID.php", {
						user_email: $('#txtEmailID').val()
					})
					.done(function(data) {
						$('#dvShowStudentDetailByEmailID').html(data);
					});
			}
		}

		function getStudentGradeDetailByEmailID(profile_type_param, email_id_param, cohort_code_param, element_row_id_for_data_population, is_custom_grade_param) {
			$('#' + element_row_id_for_data_population).html('<div style="padding:20px; display: flex; justify-content: center; align-items: center;"><div  class="spinner-border center" role="status"><span class="sr-only">Loading...</span></div></div>');
			$.post("SP_GetStudentGradeDetail.php", {
					custom_grade: is_custom_grade_param,
					profile_type: String(profile_type_param),
					email_id: email_id_param,
					cohort_code: cohort_code_param
				})
				.done(function(data) {
					$('#' + element_row_id_for_data_population).html(data);
				});
		}
	</script>
</body>

</html>