<?php require "db_connect.php" ?>
<?php
require(__DIR__ . "/../global_variable.php");
// Start the session
session_start();
if (!isset($_SESSION["msatg"])) {
	header("Location:" . $redirectUrl);
}
?>

<?php
echo "<br><br><br><br>";

?>

<!DOCTYPE html>
<html xmlns:th="http://www.thymeleaf.org">

<head>
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
	<link rel="stylesheet" href="styles/style.css" />
	<link rel="stylesheet" href="styles/index.css" />
	<title>Partner Portal</title>
	<!-- Latest compiled and minified CSS -->

	<!-- <link
	href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css"
	rel="stylesheet"
	integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3"
	crossorigin="anonymous">

<script
	src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"
	integrity="sha384-ka7Sk0Gln4gmtz2MlQnikT1wXgYsOg+OMhuP+IlRH9sENBO0LRn5q+8nbTov4+1p"
	crossorigin="anonymous"></script> -->

	<!-- Font Awesome -->
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet" />
	<!-- Google Fonts -->
	<link href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700&display=swap" rel="stylesheet" />
	<!-- MDB -->
	<link href="https://cdnjs.cloudflare.com/ajax/libs/mdb-ui-kit/4.3.0/mdb.min.css" rel="stylesheet" />
	<!-- MDB -->
	<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/mdb-ui-kit/4.3.0/mdb.min.js"></script>


	<!-- Jquery -->

	<script src="https://code.jquery.com/jquery-3.6.4.min.js" integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8=" crossorigin="anonymous"></script>


	<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
	<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
	<style>
		thead {
			background-color: #b1036a;
			color: white;
		}

		table {
			text-align: center;
		}

		.table {
			margin-bottom: 0px;
		}

		td,
		th {
			font-size: 10pt;
			padding: 7px !important;
			vertical-align: middle;
			border-bottom: 1px solid lightgrey;
		}

		a {
			text-decoration: none;
		}

		body {
			width: 100%;
		}

		.contentdata {
			background-color: #f3d4a0;
			color: black;
		}

		.all {
			padding: 0px 25px 50px;
		}

		.text-left {
			text-align: left !important;
		}

		.text-center {
			text-align: center !important;
		}

		.text-right {
			text-align: right !important;
		}

		.width-10 {
			width: 10% !important;
		}

		.width-15 {
			width: 15% !important;
		}

		.width-20 {
			width: 20% !important;
		}

		.width-25 {
			width: 25% !important;
		}

		.width-30 {
			width: 30% !important;
		}

		.custom-textbox {
			height: 40px;
			width: 100%;
			font-size: 14px;
		}
	</style>

	<script>
		var prevAccord;

		function accordDetails(ele) {

			if (prevAccord != null && prevAccord != ele) {
				document.getElementById(prevAccord).style.display = "none";
				document.getElementById(ele).style.display = "block";
				prevAccord = ele;
			} else {
				if (prevAccord == ele && document.getElementById(prevAccord).style.display == "none") {
					document.getElementById(ele).style.display = "block";
				} else if (prevAccord == ele) {
					document.getElementById(ele).style.display = "none";
				} else {
					document.getElementById(ele).style.display = "block";
				}
			}
			prevAccord = ele;
		}


		function getCohortData() {
			var cohort = document.getElementById("cohortSelection").value;
			cohort = encodeURIComponent(cohort.split('_')[0]) + "_" + cohort.split('_')[1];
			window.location = "partnerportal.php?cohortCode=" + cohort;
		}
	</script>

</head>

<body>
	<nav>
		<a class="logo"> <img src="assets/images/logo.jpeg">
		</a> <input class="menu-btn" type="checkbox" id="menu-btn" /> <label class="menu-icon" for="menu-btn"> <span class="nav-icon"></span>
		</label>


		<sec:authorize access="isAuthenticated()">

			<sec:authorize access="hasRole('STUD')">
				<ul class="menu" style="border-radius: 5px;">
					<li>
						<form action="AssessmentDetail.php" method="get" style="padding:7px;">
							<input type="submit" name="QualificationModule" value="Configure Passing Weighted Percentage" class="btn btn-primary" style="background-color:#972162; box-shadow:0px 0px 0px 0px;" />
						</form>
					</li>

					<!-- /logout must be a POST request, as csrf is enabled.
			        This ensures that log out requires a CSRF token and that a malicious user cannot forcibly log out your users.-->

					<li>
						<form action="user_logout.php" method="get" style="padding:7px;">
							<input type="submit" name="logout" value="logout" class="btn btn-primary" style="background-color:white; color:#972162; border:1px solid #972162; box-shadow:0px 0px 0px 0px;" />
						</form>
					</li>
				</ul>
			</sec:authorize>
		</sec:authorize>
	</nav>

	<?php
	if (isset($_SESSION["change_password_msg"]) && !empty($_SESSION["change_password_msg"])) {
		echo $_SESSION["change_password_msg"];
		$_SESSION["change_password_msg"] = "";
	}
	?>
	<div style="padding: 0px 25px 50px;">
		<div class="row">
			<?php
			$data_from_cohort_results = [];
			if ($_SERVER['REQUEST_METHOD'] == "GET" && isset($_GET["cohortCode"])) {

				$cohortResults = mysqli_query($connection, "CALL SP_GetModuleDetailForPartner('" . urldecode(explode("_", $_GET["cohortCode"])[0]) . "', '" . explode("_", $_GET["cohortCode"])[1] . "' , '" . $_SESSION["PartnerInformation"] . "')");

				// print_r(explode("_", $_GET["cohortCode"]));

				// var_dump($cohortResults);
				// print($_GET["cohortCode"]);
				// echo "<br> ".$_SESSION["partner_code"];

				$data_from_cohort_results = [];
				while ($row = mysqli_fetch_assoc($cohortResults)) {
					$data_from_cohort_results[] = $row;
					// print_r($row);
				}

				while (mysqli_next_result($connection)) {;
				};

				// foreach($data_from_cohort_results as $item){
				// 	print_r($item);
				// }
			}
			?>
			<!-- <div class="col-lg-2"> -->
			<!-- <label class="p-4">picture</label> -->
			<!-- </div> -->

			<div class="col-lg-6 offset-lg-6" style="display:flex; align-items:center; flex-direction:row;text-align:right">
				<span style="width:160px">Cohort Code:</span> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
				<input style="padding:5px;margin-right:15px;text-transform:uppercase;" type="text" id="txtCohortCode" name="txtCohortCode" value="" class="form-control" required />
				<input type="button" value="Search" class="btn btn-primary" style="background-color: #972162; box-shadow:0px 0px 0px 0px;" onclick="getStudentData()">
				<!-- <select id="cohortSelection"  class="cohort_selector"> -->
			</div>
		</div>

		<br>

		<div class="shadow-sm">
			<div class="row">


				<table class="table-responsive">
					<thead>
						<tr>
							<!-- <th>S.No</th> -->
							<th class="text-left width-20">Student Name</th>
							<th class="text-left width-20">Email ID</th>
							<th class="text-right width-10">Attendance</th>
							<th class="text-center width-10">Completion Status</th>
							<th class="text-center width-10">Partner Code</th>
							<th class="text-center width-10">Assessment Eligibility</th>
							<th class="text-right width-10">Result</th>
							<th class="text-right width-10">Details</th>
						</tr>
					</thead>
				</table>
			</div>

			<div>
				<div class="row" style="margin-bottom:40px">
					<div id="dvShowStudentDetail" style="padding:0px">
						<table style='width:100%; font-size:1rem;'>
							<tr>
								<td style="text-align: center;">Enter cohort code in search box</td>
							</tr>
						</table>
					</div>
				</div>
			</div>
		</div>
		<!-- ------------------------------------------------------- -->

		<!-- end of complete module loop -->





	</div>
	<div th:fragment="copy">
		<footer class="container-fluid bg-4 text-center" style="position:fixed;bottom:0px;">
			<h5>&copy; <script>
					document.write(new Date().getFullYear())
				</script> Lithan - EduClaas.</h5>
		</footer>
	</div>


	<script>
		$(document).ready(function() {
			console.log("ready!");
		});

		function getStudentData() {
			if ($('#txtCohortCode').val() != null && $('#txtCohortCode').val() != '') {
				$('#dvShowStudentDetail').html('<div style="padding:20px; display: flex; justify-content: center; align-items: center;"><div  class="spinner-border center" role="status"><span class="sr-only">Loading...</span></div></div>');
				$.post("GetStudentDetailByCohortCode.php", {
						profile_type: '',
						cohort_code: $('#txtCohortCode').val()
					})
					.done(function(data) {
						$('#dvShowStudentDetail').html(data);
					});
			}
		}

		function getPartenerDetails(user_id_param, cohort_code_param, element_row_id_for_data_population, is_custom_grade_param, email_id_param) {
			$('#' + element_row_id_for_data_population).html('<div style="padding:20px; display: flex; justify-content: center; align-items: center;"><div  class="spinner-border center" role="status"><span class="sr-only">Loading...</span></div></div>');
			$.post("SP_GetGradeDetailForPartner.php", {
					custom_grade: is_custom_grade_param,
					email_id: email_id_param,
					profile_type: '',
					user_id: user_id_param,
					cohort_code: cohort_code_param
				})
				.done(function(data) {
					$('#' + element_row_id_for_data_population).html(data);
				});
		}

		$(document).ready(function() {
			$('.cohort_selector').select2();
		});
	</script>
</body>

</html>