<?php
// Include your database connection script
require "db_connect.php";
// Check if the request method is POST
if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $qualificationcode = $_POST["qualificationcode"];
    $modulecode = $_POST["modulecode"];


    // Prepare the statement
    $stmt = mysqli_prepare($connection, "CALL SP_ADM_Insert_Update_Qualification_Module_Detail_v1(?, ?)");

    // Bind the parameters
    mysqli_stmt_bind_param($stmt, "ss", $qualificationcode, $modulecode);

    // Execute the statement
    if (mysqli_stmt_execute($stmt)) {
        $response = true;
    } else {
        $reset_message .= '<div class="alert alert-danger" style="font-size:16px; font-weight:bold;">';
        $reset_message .=  'Something went Wrong!</div>';
        $reset_message .=  '</div>';

        $_SESSION["reset_password_msg"] = $reset_message;
    }

    // Close the statement
    mysqli_stmt_close($stmt);

    // Close the database connection
    mysqli_close($connection);

    // Return the response as JSON
    header("Content-Type: application/json");
    echo json_encode($response);
} else {
    // Invalid request method
    http_response_code(405); // Method Not Allowed
    echo "Invalid request method.";
}
