<?php session_start();
include('db_connect.php');

require '../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

try {
    if (isset($_POST['save_excel_data'])) {
        $fileName = $_FILES['import_file']['name'];
        $file_ext = pathinfo($fileName, PATHINFO_EXTENSION);

        $allowed_ext = ['xls', 'csv', 'xlsx'];

        if (in_array($file_ext, $allowed_ext)) {
            $inputFileNamePath = $_FILES['import_file']['tmp_name'];
            $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($inputFileNamePath);
            $data = $spreadsheet->getActiveSheet()->toArray();
            $values = array();
            $count = "0";
            foreach ($data as $row) {
                if ($count > 0) {
                    $sr_no = $row['0'];
                    $LMSCourseID = $row['1'];
                    $MSRCohortCode = $row['2'];
                    $PartnerCode = $row['3'];
                    $CreatedOn = $row['4'];
                    $ModifiedOn = $row['5'];
                    // if (empty($CreatedOn)) {
                    //     $CreatedOn = 'null';
                    // }
                    // if (empty($ModifiedOn)) {
                    //     $ModifiedOn = 'null';
                    // }
                    $values[] = ($LMSCourseID . ', ' . $MSRCohortCode . ' ,' . $PartnerCode);
                    $msg = true;
                } else {
                    $count = "1";
                }
            }
            // echo "<pre>";
            // print_r($values);
            // die();
            // Initialize an empty string to store the values
            $sqlValues = '';

            $insertValues = [];

            // Loop through the array
            foreach ($values as $value) {
                // Split each element of the array by comma
                $values = array_map('trim', explode(',', $value));

                // Format the values and add to the insertValues array
                $insertValues[] = '(' . implode(', ', array_map(function ($val) {
                    return "'" . str_replace("'", "''", $val) . "'";
                }, $values)) . ')';
            }
            foreach ($insertValues as &$element) {
                // Remove single quotes around 'null'
                $element = str_replace("'null'", 'null', $element);
            }
            // echo "<pre>";
            // print_r($insertValues);
            // die();
            // Your final SQL query
            $sqlQuery = "INSERT INTO cohortcodemappingdetail (LMSCourseID, MSRCohortCode, PartnerCode) VALUES " . implode(', ', $insertValues) . ";";
            $result = mysqli_query($connection, $sqlQuery);
            if ($result == 1 && isset($msg)) {
                $_SESSION['message'] = "Successfully Imported";
                header('Location: ImportExcellsheet.php');
                exit(0);
            } else {
                $_SESSION['message'] = "Not Imported";
                header('Location: ImportExcellsheet.php');
                exit(0);
            }
        } else {
            $_SESSION['message'] = "Invalid File";
            header('Location: ImportExcellsheet.php');
            exit(0);
        }
    }
} catch (\Throwable $th) {
    throw $th;
}


?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>How to Import Excel Data into database in PHP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body>

    <div class="container">
        <div class="row">
            <div class="col-md-12 mt-4">

                <?php
                if (isset($_SESSION['message'])) {
                    echo "<h4>" . $_SESSION['message'] . "</h4>";
                    unset($_SESSION['message']);
                }
                ?>

                <div class="card">
                    <div class="card-header">
                        <h4>Import Excel Data into database</h4>
                    </div>
                    <div class="card-body">

                        <form action="ImportExcellsheet.php" method="POST" enctype="multipart/form-data">

                            <input type="file" name="import_file" class="form-control" />
                            <button type="submit" name="save_excel_data" class="btn btn-primary mt-3">Import</button>

                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>