<?php
// Include your database connection script
require "db_connect.php";

// Check if the request method is GET
if ($_SERVER["REQUEST_METHOD"] === "GET") {
    $qualificationmoduleID = $_GET["qualificationmoduleID"];
   
    // Call your stored procedure and fetch the data
    if (mysqli_multi_query($connection, "CALL SP_ADM_GetAssessmentGradeConfigDetails('$qualificationmoduleID');")) {
        $data = array(); // Initialize an array to store the data

        do {
            // Store the current result set
            if ($dataResults = mysqli_store_result($connection)) {
                while ($row = mysqli_fetch_assoc($dataResults)) {
                    // Append each row to the data array
                    $data[] = $row;
                }
                // Close the result set
                mysqli_free_result($dataResults);
            }
        } while (mysqli_next_result($connection));

        // Close the database connection
        mysqli_close($connection);

        // Return the response as JSON
        header("Content-Type: application/json");
        echo json_encode(['success' => true, 'data' => $data]);
    } else {
        // Handle the case where the stored procedure call failed
        mysqli_close($connection);
        header("Content-Type: application/json");
        echo json_encode(['success' => false, 'error' => mysqli_error($connection)]);
    }
} else {
    // Invalid request method
    http_response_code(405); // Method Not Allowed
    echo "Invalid request method.";
}
?>
