var Global = function () {

    
    
    this.getParameterByName = function (name, queryString) {
        name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
        var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
                results = regex.exec(queryString == undefined && queryString == null ? location.search : queryString);
        return results == null ? "" : decodeURIComponent(results[1]);
    };

    

    this.timestampDifferenceInSeconds = function (timestamp1, timestamp2) {
        var difference = timestamp1 - timestamp2;
        return Math.floor(difference / 1000); //In seconds
    }

    //Default Ajax Function
    this.WebAjaxHttpContent = function (webServiceName, webMethodName, data, isStringify, successCallback, errorCallback) {

        $.ajax({
            type: 'POST',
            async: false,
            url: WebURL + webServiceName + webMethodName,
            //contentType: "application/json; charset=utf-8",
            data: (isStringify == true) ? JSON.stringify(data) : data,
            dataType: "json",
            processData: false,
            contentType: false,

            success: function (res) {

                if (res != null)
                    successCallback(res);
                else
                    successCallback("");
            },
            error: function (xhr, textStatus, errorThrown) {
                if (xhr.status == 900) {
                    Global.NavigateTo("/Admin/Login/Index");
                }
                else
                    errorCallback(errorThrown);
            }
        });
    }
    //Default Ajax Function
    this.WebGetAjax = function (webServiceName, webMethodName, data, isStringify, successCallback, errorCallback) {
        $.ajax({
            type: 'GET',
            async: false,
            url: WebURL + webServiceName + webMethodName + data,
            contentType: "application/json; charset=utf-8",
            //data: (isStringify == true) ? "{'data':" + JSON.stringify(data) + "}" : data,
            dataType: "json",
            success: function (res) {
                if (res != null)
                    successCallback(res);
                else
                    successCallback("");
            },
            error: function () {
                errorCallback("Please check internet connectivity.");
            }
        });
    }

    this.WebAjax = function (webServiceName, webMethodName, data, isStringify, successCallback, errorCallback) {

        $.ajax({
            type: 'POST',
            async: false,
            url: WebURL + webServiceName + webMethodName,
            contentType: "application/json; charset=utf-8",
            data: (isStringify == true) ? JSON.stringify(data) : data,
            dataType: "json",
            success: function (res) {

                if (res != null)
                    successCallback(res);
                else
                    successCallback("");
            },
            error: function (xhr, textStatus, errorThrown) {
                if (xhr.status == 900) {
                    Global.NavigateTo("/Login");
                }
                else
                    errorCallback(errorThrown);
            }
        });
    }

    //Default Ajax Function
    this.WebAjaxSubmit = function (webServiceName, webMethodName, data, isStringify, successCallback, errorCallback, frm) {
        $(frm).ajaxSubmit({
            url: WebURL + webServiceName + webMethodName,
            type: 'POST',
            dataType: "json",
            contentType: "application/json; charset=utf-8",
            data: (isStringify == true) ? "{'data':" + JSON.stringify(data) + "}" : data,
            success: function (res) {
                if (res != null)
                    successCallback(res);
                else
                    successCallback("");
            },
            error: function (xhr, textStatus, errorThrown) {
                if (xhr.status == 900) {
                    Global.NavigateTo("/Admin/Login/Index");
                }
                else
                    errorCallback(errorThrown);
            }
        });
    }

    //Default Ajax Function
    this.GetJson = function (webServiceName, webMethodName, data, isStringify, successCallback, errorCallback) {
        $.getJSON(WebURL + webServiceName + webMethodName, (isStringify == true) ? "{'data':" + JSON.stringify(data) + "}" : data)
        .done(function (res) {
            if (res != null)
                successCallback(res);
            else
                successCallback("");
        })
        .fail(function (xhr, textStatus, error) {
            if (xhr.status == 900) {
                Global.NavigateTo("/Admin/Login/Index");
            }
            else
                errorCallback(xhr.responseText);
        });
    }

    this.dateFormat = function (value, type) {
        if (value != null) {
            var pattern = /Date\(([^)]+)\)/;
            var results = pattern.exec(value);
            var dt = new Date(parseFloat(results[1]));
            var year = dt.getFullYear();
            var month = (dt.getMonth() + 1);
            var day = dt.getDate();
            if (month < 9)
                month = "0" + month;
            if (day < 9)
                day = "0" + day;

            if (type == 0)
                return day + "-" + month + "-" + year;
            else if (type == 1)
                return day + "-" + month + "-" + year + " " + dt.getHours() + ":" + dt.getMinutes() + ":" + dt.getSeconds();
            else
                return dt.getDate() + "/" + (dt.getMonth() + 1) + "/" + dt.getFullYear();
        }
    }


    this.groupBy = function (xs, key) {
        return xs.reduce(function (rv, x) {
            (rv[x[key]] = rv[x[key]] || []).push(x);
            return rv;
        }, {});
    }

   
    this.getMobileOperatingSystem = function () {
        var userAgent = navigator.userAgent || navigator.vendor || window.opera;

        if (userAgent.match(/iPad/i) || userAgent.match(/iPhone/i) || userAgent.match(/iPod/i)) {
            return 2;

        }
        else if (userAgent.match(/Android/i)) {

            return 1;
        }
        else {
            return 0;
        }
    }

    return this;

}();



/**
 * Very simple way to check if a file exists on this domain.
 * Use with the jQuery library.
 *
 * Important: 	Works only on the same domain. 
 * 		Cross-domain-requests have to be done in another way (see JSONP)!
 *
 * Use: console.log(   "/data/list.json".fileExists()  );
 */
//String.prototype.fileExists = function () {
//    filename = this.trim();

//    var response = jQuery.ajax({
//        url: filename,
//        type: 'HEAD',
//        async: false
//    }).status;

//    return (response != "200") ? false : true;
//}

/**
Custom module for you to write your own javascript functions
**/
var Custom = function () {

    // private functions & variables

    var myFunc = function (text) {
        alert(text);
    }

    // public functions
    return {

        //main function
        init: function () {
            //initialize here something.            
        },

        //some helper function
        doSomeStuff: function () {
            myFunc();
        }

    };

}();

/***
Usage
***/
//Custom.init();
//Custom.doSomeStuff();