<?php
// Include your database connection script
require "../portal/db_connect.php";

// Check if the request method is GET
if ($_SERVER["REQUEST_METHOD"] === "GET") {
    // Check if user_id is set in the GET request
    if (isset($_GET["user_id"]) && !empty($_GET["user_id"])) {
        $user_id = $_GET["user_id"];

        // Construct the SQL query
        $sql = "CALL sp_get_last_submission_level_v1('$user_id');";
        error_log("SQL Query: " . $sql); // Log the SQL query for debugging

        // Call your stored procedure and fetch the data
        if (mysqli_multi_query($connection, $sql)) {
            $data = array(); // Initialize an array to store the data

            do {
                // Store the current result set
                if ($dataResults = mysqli_store_result($connection)) {
                    while ($row = mysqli_fetch_assoc($dataResults)) {
                        // Append each row to the data array
                        $data[] = $row;
                    }
                    // Close the result set
                    mysqli_free_result($dataResults);
                }
            } while (mysqli_next_result($connection));

            // Close the database connection
            mysqli_close($connection);

            // Return the response as JSON
            header("Content-Type: application/json");
            echo json_encode(['success' => true, 'data' => $data]);
        } else {
            // Handle the case where the stored procedure call failed
            mysqli_close($connection);
            header("Content-Type: application/json");
            echo json_encode(['success' => false, 'error' => 'Stored procedure call failed: ' . mysqli_error($connection)]);
        }
    } else {
        // Handle the case where user_id is missing or empty
        http_response_code(400); // Bad Request
        echo json_encode(['success' => false, 'error' => 'user_id parameter is missing or empty.']);
    }
} else {
    // Invalid request method
    http_response_code(405); // Method Not Allowed
    echo "Invalid request method.";
}
